<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DynamicList extends Model 
{

    protected $table = 'dynamic_lists';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'description_ar', 'description_en', 'type', 'data', 'status');

    public function formFields()
    {
        return $this->morphMany('App\Models\DynamicFormField', 'component');
    }

    public function stepActions()
    {
        return $this->morphMany('App\Models\ProcessStepAction', 'component');
    }

}